/**
 * \file: grl_bmpdec_jpeg.h
 *
 * \version: $Id: grl_bmpdec_jpeg.h,v 1.4 2010/01/14 13:43:29 tkniep Exp $ 
 *
 * This header file declares the functions that are provided by
 * the JPEG Decoder Module
 *
 * \component: SVG Bitmap Decoder (SVGBMPDEC)
 *
 * \author: T. Kniep (tkniep@de.adit-jv.com)
 *
 * \copyright: (c) 2009 ADIT Corporation
 *
 ***********************************************************************/
 
#ifndef GRL_BMPDEC_JPEG_H
#define GRL_BMPDEC_JPEG_H

#include <adit_typedef.h>
#include <svg_bitmap_decoder.h>
#include <svg_error.h>

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************************
 *   Macro definitions
 *******************************************************************************************/

/** Zoom factor is 1 (factor = GRL_BMPDEC_ZOOM_ORG / 1024)  */
#define GRL_BMPDEC_ZOOM_ORG                     (1024)

/* The rotation angles supported by the libjpeg */
#define GRL_BMPDEC_JPEG_ROTATE_0_DEGREE         (0)     /**< 0 degrees rotation         */
#define GRL_BMPDEC_JPEG_ROTATE_90_DEGREE        (90)    /**< 90 degrees rotation        */
#define GRL_BMPDEC_JPEG_ROTATE_180_DEGREE       (180)   /**< 180 degrees rotation       */
#define GRL_BMPDEC_JPEG_ROTATE_270_DEGREE       (270)   /**< 270 degrees rotation       */

/** Length of date and time info       */
#define GRL_BMPDEC_JPEG_DTIME_LEN               (20)

/** JPEG is normally 24 bits per pixel */
#define GRL_BMPDEC_JPEG_DEPTH                   (24)

/** JFIF header size */
#define GRL_BMPDEC_JPEG_JFIF_HEADER_SIZE        (10)

/** JFIF header bytes */
#define GRL_BMPDEC_JPEG_JFIF_HEADER             { 0xff, 0xd8, 0xff, 0xe0, 0x00, 0x10, 0x4a, 0x46, 0x49, 0x46 }



/*******************************************************************************************
 *   Function prototypes
 *******************************************************************************************/

/**
 * Decode JPEG bitmap.
 * The libjpeg is used to decode the JPEG into the specified destination.
 *
 * \param[in]   *p_decode_info          Pointer to decoding info
 *
 * \return      SVG_NO_ERROR            Decoding was successful
 * \return      SVG_OUT_OF_MEMORY       There was not enough memory for decoding
 * \return      SVG_INVALID_VALUE       Some parameter is incorrect or missing
 * \return      SVG_BMPDEC_INVALID_CLIP The clip rect is not valid
 * \return      SVG_BMPDEC_DEC_ERROR    The decoder returned an error
 *
 */
extern  SVGError GRL_BMPDEC_draw_image_JPEG( GRL_BMPDEC_dec_info *p_decode_info );


/**
 * Provide information about JPEG.
 * The libjpeg is used to read image information about the encoded JPEG.
 *
 * \param[in]   *ctx                    Context for Bitmap Decoder
 * \param[in]   *p_image                Pointer to image definition structure.
 * \param[out]  *image_info             Pointer to image info structure containing the results
 *
 * \return      SVG_NO_ERROR            Information retrieval was successful
 * \return      SVG_INVALID_VALUE       Some parameter is incorrect or missing
 * \return      SVG_BMPDEC_DEC_ERROR    The decoder returned an error
 * 
 */
extern  SVGError GRL_BMPDEC_get_image_info_JPEG( const SVGContextBmpDec  *ctx,
                                                 const SVGImage          *p_image,
                                                 SVGImageInfo            *image_info );



#ifdef __cplusplus
}
#endif

#endif  /* GRL_BMPDEC_JPEG_H */

